import java.util.*;

/*
 * Generic state interface that will be used by the solver(s).
 */
public interface State {
    // return the next states.
    public Collection<State> next();
    // check if a state is final, i.e. the goal of the search
    public boolean isGoal();
    // Return parent state
    public State getPrevious();
}