# GameSolver

A modular Java framework to solve classic combinatorial puzzles using generic
search algorithms, with a unified interface for state management and solution
finding.

## ✅ Supported Puzzles
The supported puzzles are the  **N-Puzzle**, the **N-Queens** puzzle, and the
**Goat-Wolf-Cabbage river crossing**

## 🧠 Solvers
Currently the supported solvers are a depth-first search and a breadth-first
search solver. Note that some problems can be solved more efficiently with more
advanced search algorithms (e.g., A* search).

## 📦 Project Structure

```
GameSolver/
├── BFSSolver.java         # Breadth-First Search solver implementation
├── DFSSolver.java         # Depth-First Search solver implementation
├── GoatState.java         # State representation for the Goat-Wolf-Cabbage puzzle
├── NPuzzleState.java      # State representation for the N-Puzzle
├── NQueensState.java      # State representation for the N-Queens problem
├── Solver.java            # Generic solver interface
├── State.java             # Generic state interface
├── Main.java              # Entry point for running the solvers
├── puzzles                # Input puzzles for N-puzzle (see local README for description)
└── README.md              # Project documentation
```

## 🚀 Running the Project

To compile:

```bash
javac Main.java
```

To run:
```bash
java Main NPuzzle input.txt   # N-puzzle, where input.txt is the file that describes the initial board
java Main NQueens N           # N-Queens puzzle, where N is the number of queens
java Main goat                # Goat puzzle
```

## 🧱 Extensibility

You can easily add new puzzles by creating a new YourPuzzleState.java file with
a class that implements the interface `State`.

You can add new solvers by creating a new solver class that implements the
interface `Solver`.

## 📄 License

MIT License.