import java.util.*;

public class Main {
    public static void main(String args[]) {

        if (args.length == 0) {
            System.out.println("Please specify a puzzle: goat | nqueens | npuzzle");
            return;
        }

        String puzzle = args[0].toLowerCase();
        State initialState = null;
        Solver solver = null;

        switch (puzzle) {
            case "goat":
                initialState = new GoatState();
                // Pick a solver
                solver = new BFSolver();
                break;
            case "nqueens":
                if (args.length < 2) {
                    System.out.println("Please specify the number of queens.");
                    return;
                }
                initialState = new NQueensState(Integer.parseInt(args[1]));
                // Pick a solver
                solver = new DFSolver();
                break;
            case "npuzzle":
                if (args.length < 2) {
                    System.out.println("Please provide an input file.");
                    return;
                }
                initialState = NPuzzleState.readInput(args[1]);
                // Pick a solver
                solver = new BFSolver();
                break;
            default:
                System.out.println("Unknown puzzle: " + puzzle);
                System.out.println("Available options: goat | nqueens | npuzzle");
                return;
        }

        // Solve the puzzle
        State result = solver.solve(initialState);
        // Print the solution
        if (result == null) {
            System.out.println("No solution found.");
        } else {
            printSolution(result);
        }
    }

    /*
     * Recursively prints the steps from initialState state to goal.
     */
    private static void printSolution(State s) {
        if (s.getPrevious() != null) {
            printSolution(s.getPrevious());
        }
        System.out.println(s);
    }
}
