import java.util.*;
/*
 * A depth-first search solver implementation.
 */
public class DFSolver implements Solver {

    public State solve(State init) {
        // A double-ended queue used as a stack
        Deque<State> next = new ArrayDeque<State>();
        // A set for marking visited nodes
        Set<State> visited = new HashSet<State>();

        // add initial state to the stack
        next.addFirst(init);

        // while the stack is not empty ...
        while (!next.isEmpty()) {

            // pop the next state from the stack
            State s = next.removeFirst();

            // if goal is reached, return
            if (s.isGoal()) return s;

            // mark node as visited
            visited.add(s);
            
            // ... and examine its children
            for (State n : s.next()) {

                if (!visited.contains(n))
                    next.addFirst(n);
            }
        }
        // no solution found
        return null;
    }
}